/*-------------------------------------------------

		GKApi

		MOD 2003/08/12:
					Aggiunto metodo GK_Terminate()
		MOD 2006/09/06:
					Compilabile su Linux
		MOD 2006/09/12:
					Aggiunta direttiva 'extern "C"' per progetti C++
		MOD 2007/01/19:
					Aggiunto il metodo GK_ConnectEx
					Aggiunto il valore GK_INVALID_PARAMETER all'enum GK_Reply_t
		MOD 2007/05/18:
					Aggiunte @define per AIX
		MOD 2007/07/02:
					Eliminata la definizione del tipo GK_Market_Status_t
					Aggiunto il valore GK_DATA_ERROR all'enum GK_Reply_t
					Aggiunto il valore GK_BINARY_INQUIRE_DATA_NOTIFICATION all'enum GK_Notification_t
					Aggiunta la definizione dei tipi GK_Length_t e GK_Byte_t
					Aggiunti i metodi GK_GetBinaryData, GK_CreateUnzipHelper, GK_InitializeUnzipHelper,
					GK_ClearUnzipHelper, GK_DestroyUnzipHelper e GK_UnzipBinaryData

		MOD 2015/12/07:		Aggiunto l'attributo di visibilità per i sistemi LINUX, SOLARIS e AIX

---------------------------------------------------*/

#ifndef __GKAPI__
#define __GKAPI__


/* definitions for WIN32 dll */

#ifdef WIN32
#	ifdef GKAPI_DLL_EXPORTS
#		define GKAPI_DLL __declspec(dllexport)
#	else
#		define GKAPI_DLL __declspec(dllimport)
#	endif
#elif (defined(SOLARIS) || defined(LINUX) || defined(AIX))
#	if __GNUC__ >= 4
#		define GKAPI_DLL __attribute__ ((visibility ("default")))
#	else
#		define GKAPI_DLL
#	endif
#endif

#ifdef WIN32
#	include <winsock2.h>
#endif

typedef enum tagGK_Reply_t{
	GK_SUCCESS					= 0,
	GK_INVALID_CONFIG_FILE		= 1,
	GK_INVALID_SERVER			= 2,
	GK_INVALID_HANDLE			= 3,
	GK_API_ERROR				= 4,
	GK_API_NOT_INITIALIZED		= 5,
	GK_API_ALREADY_INITIALIZED	= 6,
	GK_INVALID_CONTEXT			= 7,
	GK_SERVER_UNREACHABLE		= 8,
	GK_INVALID_TRANSACTIONID	= 9,
	GK_INVALID_SUBSCRIPTIONID	= 10,
	GK_COMMAND_ON_GOING			= 11,
	GK_TYPE_MISMATCH			= 12,
	GK_CONTEXT_BUSY				= 13,
	GK_MISSING_CONNECTION		= 14,
	GK_OVERLOAD					= 15,
	GK_FAILED					= 16,
	GK_INVALID_PARAMETER		= 17,
	GK_DATA_ERROR				= 18,
	GK_MORE_OUTPUT_AVAILABLE	= 19,
	GK_MORE_INPUT_NEEDED		= 20
} GK_Reply_t;

typedef enum tagGK_MarketReply_t{
	GK_REQUEST_ACCEPTED			= 0,
	GK_REQUEST_REJECTED			= 1,
	GK_REQUEST_WARNING			= 2,
	GK_ALREADY_CONNECTED		= 3,
	GK_INVALID_MARKET			= 4,
	GK_INVALID_CLASS			= 5,
	GK_NO_MARKET_CONTEXT		= 6,
	GK_INVALID_FIELD			= 7,
	GK_REQUEST_ON_GOING			= 8,
	GK_LICENCE_ERROR			= 9,
	GK_PROPOSAL_ALREADY_EXISTS	= 10,
	GK_PROPOSAL_NOT_EXISTS		= 11,
	GK_INVALID_PROPOSAL_KEY		= 12,
	GK_MISSING_FIELD_VALUE		= 13,
	GK_ACCESS_DENIED			= 14,
	GK_INSUFFICIENT_PRIVILEGES	= 15,
	GK_WRONG_FIELD_VALUE		= 16,
	GK_SERVER_NOT_AVAILABLE		= 17,
	GK_NOT_CONNECTED			= 18,
	GK_WRONG_PARAMETER			= 19,
	GK_TIMED_OUT				= 20
} GK_MarketReply_t;

typedef enum tagGK_ClassType_t{
	GK_META_CLASS			= 0,
	GK_MARKET_CLASS			= 1
} GK_ClassType_t;

typedef enum tagGK_Status_t{
	GK_CONNECTION_UP		= 0,
	GK_CONNECTION_DOWN		= 1,
	GK_CONNECTION_WARNING	= 2,
	GK_SERVER_DOWN			= 3
} GK_Status_t;

typedef enum tagGK_Chain_t{
	GK_CHAIN_CONTINUE	= 0,
	GK_CHAIN_END		= 1,
	GK_CHAIN_NO_DATA	= 2
} GK_Chain_t;

typedef enum tagGK_Notification_t{
	GK_MARKET_STATUS_NOTIFICATION			= 0,
	GK_CONNECTION_RESPONSE_NOTIFICATION		= 1,
	GK_DISCONNECTION_RESPONSE_NOTIFICATION	= 2,
	GK_TRANSACTION_STATUS_NOTIFICATION		= 3,
	GK_SUBSCRIPTION_STATUS_NOTIFICATION		= 4,
	GK_SUBMIT_RESPONSE_NOTIFICATION			= 5,
	GK_SUBSCRIBE_RESPONSE_NOTIFICATION		= 6,
	GK_UNSUBSCRIBE_RESPONSE_NOTIFICATION	= 7,
	GK_INQUIRE_RESPONSE_NOTIFICATION		= 8,
	GK_NOTIFY_DATA_NOTIFICATION				= 9,
	GK_INQUIRE_DATA_NOTIFICATION			= 10,
	GK_SET_NOTIFICATION_PERIOD_NOTIFICATION = 11,
	GK_BINARY_INQUIRE_DATA_NOTIFICATION		= 12
} GK_Notification_t;

#ifdef WIN32
typedef SOCKET GK_Connection_t;
#elif defined(SOLARIS)
typedef int GK_Connection_t;
#elif defined(LINUX)
typedef int GK_Connection_t;
#elif defined(AIX)
typedef int GK_Connection_t;
#endif


typedef const void* GK_Tag_t;

typedef long GK_Data_t;

typedef long GK_Transaction_t;

typedef long GK_Subscription_t;

typedef long GK_Inquire_t;

typedef long GK_Context_t;

typedef unsigned int GK_Length_t;

typedef unsigned char GK_Byte_t;

typedef void* GK_UnzipHelper_t;

typedef struct tagGK_ApplicationData_t{
	GK_ClassType_t		ClassType;
	const char*			ClassName;
	const char*			Data;
	int					UseTransaction;
	GK_Transaction_t	localTransactionId;
} GK_ApplicationData_t;

typedef void(*GK_Callback_t)(
	GK_Context_t	Context,
	GK_Data_t		gkData,
	GK_Tag_t		gkTag
);


/*-------------------------------------------------

		 function prototypes

---------------------------------------------------*/
#ifdef __cplusplus
extern "C" {
#endif

GKAPI_DLL GK_Reply_t GK_Initialize(const char* ConfigFile);

GKAPI_DLL GK_Reply_t GK_Terminate();

GKAPI_DLL GK_Reply_t GK_CreateContext(const char* 			GATEMarketServer,
								GK_Context_t*		pContext,
								GK_Connection_t*	pConnection);
								
GKAPI_DLL GK_Reply_t GK_Dispatch(GK_Context_t Context);

GKAPI_DLL GK_Reply_t GK_ReleaseContext(GK_Context_t Context);

GKAPI_DLL GK_Reply_t GK_Connect(GK_Context_t		Context,
						const char*		UserName,
						const char*		Password,
						const char*		Market,
						GK_Callback_t	pCallbackResponse,
						GK_Callback_t	pCallbackMarketStatus,
						GK_Tag_t		gkTag);

GKAPI_DLL GK_Reply_t GK_CreateTransaction(GK_Context_t		Context,
								GK_Transaction_t* pTransactionID);
				
GKAPI_DLL GK_Reply_t GK_Submit(GK_Context_t				Context,
						GK_Transaction_t		TransactionID,
						GK_ApplicationData_t*	ApplicationData,
						GK_Callback_t			pCallbackResponse,
						GK_Tag_t				gkTag);
						
GKAPI_DLL GK_Reply_t GK_Subscribe(GK_Context_t			Context,
						GK_ApplicationData_t*	ApplicationData,
						GK_Callback_t			pCallbackResponse,
						GK_Callback_t			pCallbackData,
						GK_Tag_t				gkTag,
						GK_Subscription_t*		pSubscriptionID);						

GKAPI_DLL GK_Reply_t GK_DestroyTransaction(GK_Context_t Context, GK_Transaction_t TransactionID);

GKAPI_DLL GK_Reply_t GK_UnSubscribe(GK_Context_t			Context,
							GK_Subscription_t	SubscriptionID,
							GK_Callback_t		pCallbackResponse,
							GK_Tag_t			gkTag);

GKAPI_DLL GK_Reply_t GK_Inquire(GK_Context_t				Context,
						GK_ApplicationData_t*	ApplicationData,
						GK_Callback_t			pCallbackResponse,
						GK_Callback_t			pCallbackData,
						GK_Tag_t				gkTag,
						GK_Inquire_t*			pInquireID);

GKAPI_DLL GK_Reply_t GK_Disconnect(GK_Context_t		Context,
							GK_Callback_t	pCallbackResponse,
							GK_Tag_t		gkTag);

GKAPI_DLL GK_Reply_t GK_GetVersion(char** Company,
						 char** Version,
						 char** CreationDate,
						 char** Comment);

GKAPI_DLL GK_Reply_t GK_SetNotificationPeriod(GK_Context_t			Context,
											   GK_Subscription_t	SubscriptionID,
											   long					NotificationPeriod_sec,
											   GK_Callback_t 		pCallbackResponse, 
											   GK_Tag_t  			gkTag);

GKAPI_DLL GK_Reply_t GK_SubscribeEx(GK_Context_t			Context,
									GK_ApplicationData_t*	ApplicationData,
									long					NotificationPeriod,
									GK_Callback_t			pCallbackResponse,
									GK_Callback_t			pCallbackData,
									GK_Tag_t				gkTag,
									GK_Subscription_t*		pSubscriptionID);

GKAPI_DLL GK_Reply_t GK_FreeString(char* data);

GKAPI_DLL GK_Reply_t GK_GetNotificationType(GK_Data_t gkData, GK_Notification_t* pNotificationType);

GKAPI_DLL GK_Reply_t GK_GetConnectionStatus(GK_Data_t gkData, GK_Status_t* pMarketStatus);

GKAPI_DLL GK_Reply_t GK_GetTransactionID(GK_Data_t gkData, GK_Transaction_t* pTransaction);

GKAPI_DLL GK_Reply_t GK_GetSubscriptionID(GK_Data_t gkData, GK_Subscription_t* pSubscription);

GKAPI_DLL GK_Reply_t GK_GetInquireID(GK_Data_t gkData, GK_Inquire_t* pInquire);

GKAPI_DLL GK_Reply_t GK_GetMarketResponse(GK_Data_t gkData, GK_MarketReply_t* pReply,	char** Specification);	
	
GKAPI_DLL GK_Reply_t GK_GetClassName(GK_Data_t gkData, char** ClassName,	GK_ClassType_t* pClassType);										

GKAPI_DLL GK_Reply_t GK_DecodeData(GK_Data_t gkData, char** data);

GKAPI_DLL GK_Reply_t GK_GetValueString(GK_Data_t gkData, const char* key, char** value);

GKAPI_DLL GK_Reply_t GK_GetValueLong(GK_Data_t gkData, const char* key, long* value);

GKAPI_DLL GK_Reply_t GK_GetValueDouble(GK_Data_t gkData, const char* key, double* value);

GKAPI_DLL GK_Reply_t GK_GetValueInt(GK_Data_t gkData, const char* key, int* value);

GKAPI_DLL GK_Reply_t GK_GetChain(GK_Data_t gkData, GK_Chain_t* pChain);

GKAPI_DLL GK_Reply_t GK_CreateApplicationData(const char* ClassName,
							GK_ClassType_t ClassType,
							GK_ApplicationData_t** pApplicationData);
							
GKAPI_DLL GK_Reply_t GK_EncodeData(GK_ApplicationData_t* pApplicationData,
							const char* data);
							
GKAPI_DLL GK_Reply_t GK_SetValueString(GK_ApplicationData_t* pApplicationData,
							const char* key,
							const char* value);
							
GKAPI_DLL GK_Reply_t GK_SetValueLong(GK_ApplicationData_t* pApplicationData,
							const char* key,
							long value);
							
GKAPI_DLL GK_Reply_t GK_SetValueDouble(GK_ApplicationData_t* pApplicationData,
							const char* key,
							double value);
							
GKAPI_DLL GK_Reply_t GK_SetValueInt(GK_ApplicationData_t* pApplicationData,
							const char* key,
							int value);
						
GKAPI_DLL GK_Reply_t GK_DestroyApplicationData(GK_ApplicationData_t* pAppicationData);																																										

GKAPI_DLL GK_Reply_t GK_SetTransactionID(GK_ApplicationData_t* pApplicationData, GK_Transaction_t Transaction);

GKAPI_DLL GK_Reply_t GK_ConnectEx(GK_Context_t		Context,
								const char*		UserName,
								const char*		Password,
								const char*		Market,
								const char*		ClientIP,
								const char*		ClientData,
								GK_Callback_t	pCallbackResponse,
								GK_Callback_t	pCallbackMarketStatus,
								GK_Tag_t		gkTag);

GKAPI_DLL GK_Reply_t GK_GetBinaryData(GK_Data_t gkData, GK_Byte_t** pData, GK_Length_t* pDataLength);

GKAPI_DLL GK_Reply_t GK_CreateUnzipHelper(GK_UnzipHelper_t* pUnzipHelper);

GKAPI_DLL GK_Reply_t GK_InitializeUnzipHelper(GK_UnzipHelper_t	unzipHelper,
									const GK_Byte_t*	Data,
									GK_Length_t			DataLength);

GKAPI_DLL GK_Reply_t GK_ClearUnzipHelper(GK_UnzipHelper_t unzipHelper);

GKAPI_DLL GK_Reply_t GK_DestroyUnzipHelper(GK_UnzipHelper_t unzipHelper);

GKAPI_DLL GK_Reply_t GK_UnzipBinaryData(GK_UnzipHelper_t	unzipHelper,
									char*			buffer,
									GK_Length_t		bufferLength,
									GK_Length_t*	pDataLength);

#ifdef __cplusplus
}
#endif

#endif //__GKAPI__
