
#include "stdafx.h"

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <time.h>
#include <process.h>
 
#include "GKApi.h"

// Definizione delle stringhe di formattazione per Windows
#if _MSC_VER >= 1800
#	include <inttypes.h>
#else
#	ifndef PRIuPTR
#		define PRIuPTR	"u"
#	endif
#endif

#define GKF_CONNECTION_T_PRINTF_FORMAT	PRIuPTR
#define SCAN_FORMAT_INT					"%4d"
#define SCAN_FORMAT_LONG				"%4ld"

#define MSG_MAX_LEN			2000
#define DISPATCH_PERIOD		5
#define MAX_CONTEXT_NUM		256

struct _DISP_DATA
{
	int				iValid;
	GK_Context_t	gkContext;
	GK_Connection_t	gkConnection;
	int				iEndDispatch;
	HANDLE			hndThread;
};

typedef struct _DISP_DATA DISP_DATA;

int g_bLogOnFile=0;
FILE* g_pOutput=NULL;
DISP_DATA g_aDispData[MAX_CONTEXT_NUM];
int g_bStartUnzip=0;
GK_UnzipHelper_t g_UnzipHelper=NULL;
int g_iChunk = 32768;

void fprintfTimestamp(FILE* pFile, const char* pszMsg)
{
	unsigned long hour;
	unsigned long min;
	unsigned long sec;
	unsigned long msec;
	SYSTEMTIME sysTime;

	GetLocalTime(&sysTime);

	hour = sysTime.wHour;
	min = sysTime.wMinute;
	sec = sysTime.wSecond;
	msec = sysTime.wMilliseconds;

	fprintf(pFile,"%02lu:%02lu:%02lu.%03lu %s\n",hour,min,sec,msec,pszMsg);
	fflush(pFile);
}

void fprintTimestamp(const char* pszMsg)
{
	fprintfTimestamp(stdout, pszMsg);
}

void Inflate(GK_Context_t context, unsigned int uiLen, const char* Data){
	char szMsg[MSG_MAX_LEN];
	GK_Reply_t gkRes;
	GK_Length_t gkLen;
	char* out;
	FILE* pFile=NULL;

	out=(char*)malloc(g_iChunk*sizeof(char));
	if(out==NULL){
		sprintf(szMsg, "CTXT %ld: INFLATE: malloc failed\n", context);
		fprintTimestamp(szMsg);
		return;
	}

	sprintf(szMsg, "CTXT %ld: INFLATE: start; len=%u", context, uiLen);
	fprintTimestamp(szMsg);

	if(g_bLogOnFile==1){
		fprintf(g_pOutput, "CTXT %ld: INFLATE: start; len=%u\n", context, uiLen);
		fflush(g_pOutput);
	}

	gkRes=GK_InitializeUnzipHelper(g_UnzipHelper,Data,uiLen);
	if(gkRes != GK_SUCCESS){
		sprintf(szMsg, "CTXT %ld: INFLATE: ERRORE: GK_InitializeUnzipHelper failed; res=%d\n", context, gkRes);
		fprintTimestamp(szMsg);

		if(g_bLogOnFile==1){
			fprintf(g_pOutput, "CTXT %ld: INFLATE: ERRORE: GK_InitializeUnzipHelper failed; res=%d\n\n", context, gkRes);
			fflush(g_pOutput);
		}
		free(out);
		return;
	}

	do
	{
		gkRes=GK_UnzipBinaryData(g_UnzipHelper,out,g_iChunk,&gkLen);

		sprintf(szMsg, "CTXT %ld: INFLATE: res=%d, len=%u", context, gkRes, gkLen);
		fprintTimestamp(szMsg);

		if(g_bLogOnFile==1){
			fprintf(g_pOutput, "CTXT %ld: INFLATE: res=%d, len=%u\n", context, gkRes, gkLen);
			fflush(g_pOutput);

			pFile=fopen(".\\OutUnzip.log","a");
			if(pFile){
				fwrite(out,1,gkLen,pFile);
				fclose(pFile);
			}
		}
	}
	while(gkRes==GK_MORE_OUTPUT_AVAILABLE);

	sprintf(szMsg, "CTXT %ld: INFLATE: stop; res=%d", context, gkRes);
	fprintTimestamp(szMsg);

	if(g_bLogOnFile==1){
		fprintf(g_pOutput, "CTXT %ld: INFLATE: stop; res=%d\n", context, gkRes);
		fflush(g_pOutput);
	}

	if(gkRes!=GK_MORE_INPUT_NEEDED){
		gkRes=GK_ClearUnzipHelper(g_UnzipHelper);
		if(gkRes != GK_SUCCESS){
			sprintf(szMsg, "CTXT %ld: INFLATE: GK_ClearUnzipHelper res=%d\n", context, gkRes);
			fprintTimestamp(szMsg);

			if(g_bLogOnFile==1){
				fprintf(g_pOutput, "CTXT %ld: INFLATE: GK_ClearUnzipHelper res=%d\n\n", context, gkRes);
				fflush(g_pOutput);
			}
		}
	}
	else{
		printf("\n");
		if(g_bLogOnFile==1){
			fprintf(g_pOutput,"\n");
			fflush(g_pOutput);
		}
	}

	free(out);
}

void marketStatusCallback(GK_Context_t context, GK_Data_t gkData, GK_Tag_t gkTag){
	GK_Reply_t gkRes;
	GK_Notification_t gkNotificationType;
	GK_Status_t gkConnectionStatus;
	char szMsg[MSG_MAX_LEN];

	gkRes=GK_GetNotificationType(gkData,&gkNotificationType);
	if(gkRes!=GK_SUCCESS){
		sprintf(szMsg, "CTXT %ld: MARKET STATUS CALLBACK: GK_GetNotificationType() failed. Res=%d\n", context, gkRes);
		fprintTimestamp(szMsg);
	}
	else{
		gkRes=GK_GetConnectionStatus(gkData,&gkConnectionStatus);
		if(gkRes!=GK_SUCCESS){
			sprintf(szMsg, "CTXT %ld: MARKET STATUS CALLBACK: GK_GetConnectionStatus() failed. Res=%d. Type=%d\n", context, gkRes, gkNotificationType);
			fprintTimestamp(szMsg);
		}
		else{
			sprintf(szMsg, "CTXT %ld: MARKET STATUS CALLBACK: Type=%d. Status=%d\n", context, gkNotificationType, gkConnectionStatus);
			fprintTimestamp(szMsg);
		}
	}
}

void submitResponseCallback(GK_Context_t context, GK_Data_t gkData, GK_Tag_t gkTag){
	GK_Reply_t			gkRes;
	GK_Notification_t	not;
	GK_MarketReply_t	mr;
	GK_Transaction_t	trx;
	char*				spec;
	char				szMsg[MSG_MAX_LEN];

	gkRes=GK_GetNotificationType(gkData, &not);
	if(gkRes!=GK_SUCCESS)
		not=-1;

	gkRes=GK_GetMarketResponse(gkData, &mr, &spec);
	if(gkRes!=GK_SUCCESS)
		mr=-1;

	gkRes=GK_GetTransactionID(gkData, &trx);
	if(gkRes!=GK_SUCCESS)
		trx=-1;

	sprintf(szMsg, "CTXT %ld: SUBMIT RESPONSE CALLBACK: NotificationType=%d, TransactionID=%ld, ResultCode=%d, Specification=\"%s\"\n", context, not, trx, mr, spec);
	fprintTimestamp(szMsg);
	
	GK_FreeString(spec);
}

void NotificationPeriodResponseCallback(GK_Context_t context, GK_Data_t gkData, GK_Tag_t gkTag){
	GK_Subscription_t	SubscriptionId;
	GK_MarketReply_t	mr;
	char*				spec;
	char				szMsg[MSG_MAX_LEN];

	if (GK_GetSubscriptionID(gkData, &SubscriptionId) != GK_SUCCESS){
		sprintf(szMsg, "CTXT %ld: NOTIFICATION PERIOD RESPONSE CALLBACK: GK_GetSubscriptioID failed\n", context);
		fprintTimestamp(szMsg);
		return;
	}
	
	if (GK_GetMarketResponse(gkData, &mr, &spec) != GK_SUCCESS){
		sprintf(szMsg, "CTXT %ld: NOTIFICATION PERIOD RESPONSE CALLBACK: GK_GetMarketResponse failed. SubscriptionId = %ld\n", context, SubscriptionId);
		fprintTimestamp(szMsg);
		return;
	}

	sprintf(szMsg, "CTXT %ld: NOTIFICATION PERIOD RESPONSE CALLBACK: SubscriptionId = %ld. Spec=\"%s\"\n", context, SubscriptionId, spec);
	fprintTimestamp(szMsg);

	GK_FreeString(spec);
}

void disconnectResponseCallback(GK_Context_t context, GK_Data_t gkData, GK_Tag_t gkTag){
	GK_Notification_t	not;
	GK_MarketReply_t	mr;
	char*				spec;
	char				szMsg[MSG_MAX_LEN];

	GK_GetNotificationType(gkData, &not);
	GK_GetMarketResponse(gkData, &mr, &spec);

	sprintf(szMsg, "CTXT %ld: DISCONNECT RESPONSE CALLBACK: NotificationType=%d, MarketStatus=%d, Specification=\"%s\"\n", context, not, mr, spec);
	fprintTimestamp(szMsg);
	
	GK_FreeString(spec);	
}

void connectResponseCallback(GK_Context_t context, GK_Data_t gkData, GK_Tag_t gkTag){
	
	GK_Notification_t	not;
	GK_MarketReply_t	mr;
	char*				spec;
	char				szMsg[MSG_MAX_LEN];
	
	GK_GetNotificationType(gkData, &not);
	GK_GetMarketResponse(gkData, &mr, &spec);

	sprintf(szMsg, "CTXT %ld: CONNECT RESPONSE CALLBACK: NotificationType=%d, MarketStatus=%d, Specification=\"%s\"\n", context, not, mr, spec);
	fprintTimestamp(szMsg);
	
	GK_FreeString(spec);	
}

void subscribeResponseCallback(GK_Context_t context, GK_Data_t gkData, GK_Tag_t gkTag){
	GK_Reply_t	Res;
	GK_Subscription_t	SubscriptionId;
	GK_MarketReply_t gkMarketReply;
	char* pszgkSpecification=NULL;
	char szMsg[MSG_MAX_LEN];

	Res=GK_GetSubscriptionID(gkData, &SubscriptionId);
	if (Res != GK_SUCCESS)
	{
		sprintf(szMsg, "CTXT %ld: SUBSCRIBE RESPONSE CALLBACK: GK_GetSubscriptioID failed. Error=%d\n", context, Res);
		fprintTimestamp(szMsg);
		return;
	}

	Res=GK_GetMarketResponse(gkData,&gkMarketReply,&pszgkSpecification);
	if (Res != GK_SUCCESS)
	{
		sprintf(szMsg, "CTXT %ld: SUBSCRIBE RESPONSE CALLBACK: GK_GetMarketResponse failed. Error=%d. SubscriptionId=%ld\n", context, Res, SubscriptionId);
		fprintTimestamp(szMsg);
		return;
	}
	else
	{
		sprintf(szMsg, "CTXT %ld: SUBSCRIBE RESPONSE CALLBACK: SubscriptionId=%ld. MarketReply=%d. Spec=\"%s\"\n", context, SubscriptionId, gkMarketReply, pszgkSpecification);
		fprintTimestamp(szMsg);
		GK_FreeString(pszgkSpecification);
	}
}

void subscribeDataCallback(GK_Context_t context, GK_Data_t gkData, GK_Tag_t gkTag){
	GK_Reply_t	Res;
	char*	data=NULL;
	char*	ClassName;
	GK_ClassType_t ClassType;
	GK_Subscription_t	SubscriptionId;
	char szMsg[MSG_MAX_LEN];
	
	Res=GK_GetSubscriptionID(gkData, &SubscriptionId);
	if (Res != GK_SUCCESS)
	{
		sprintf(szMsg, "CTXT %ld: SUBSCRIBE DATA CALLBACK: ERRORE: GK_GetSubscriptioID=%d\n", context, Res);
		fprintTimestamp(szMsg);
		return;
	}
	else
	{
		sprintf(szMsg, "CTXT %ld: SUBSCRIBE DATA CALLBACK: SubscriptionId=%ld", context, SubscriptionId);
		fprintTimestamp(szMsg);
	}

	GK_GetClassName(gkData, &ClassName, &ClassType);
	
	printf("  ClassName = %s, ClassType = %d\n", ClassName, ClassType);
	
	GK_FreeString(ClassName);
	
	Res=GK_DecodeData(gkData, &data);
	if(Res != GK_SUCCESS){
		sprintf(szMsg, "CTXT %ld: SUBSCRIBE DATA CALLBACK: ERRORE: GK_DecodeData=%d\n", context, Res);
		fprintTimestamp(szMsg);
		return;
	}
	
	printf("  Data = %s\n\n", data);
	
	GK_FreeString(data);
}

void unsubscribeResponseCallback(GK_Context_t context, GK_Data_t gkData, GK_Tag_t gkTag){

	GK_Reply_t	Res;
	GK_Subscription_t	SubscriptionId;
	GK_MarketReply_t gkMarketReply;
	char* pszgkSpecification=NULL;
	char szMsg[MSG_MAX_LEN];

	Res=GK_GetSubscriptionID(gkData, &SubscriptionId);
	if (Res != GK_SUCCESS)
	{
		sprintf(szMsg, "CTXT %ld: UNSUBSCRIBE RESPONSE CALLBACK: GK_GetSubscriptioID failed. Error=%d\n", context, Res);
		fprintTimestamp(szMsg);
		return;
	}

	Res=GK_GetMarketResponse(gkData,&gkMarketReply,&pszgkSpecification);
	if (Res != GK_SUCCESS)
	{
		sprintf(szMsg, "CTXT %ld: UNSUBSCRIBE RESPONSE CALLBACK: GK_GetMarketResponse failed. Error=%d. SubscriptionId=%ld\n", context, Res, SubscriptionId);
		fprintTimestamp(szMsg);
		return;
	}
	else
	{
		sprintf(szMsg, "CTXT %ld: UNSUBSCRIBE RESPONSE CALLBACK: SubscriptionId=%ld. MarketReply=%d. Spec=\"%s\"\n", context, SubscriptionId, gkMarketReply, pszgkSpecification);
		fprintTimestamp(szMsg);
		GK_FreeString(pszgkSpecification);
	}
}

void inquireResponseCallback(GK_Context_t context, GK_Data_t gkData, GK_Tag_t gkTag){
	GK_Reply_t			gkRes;
	GK_MarketReply_t	Reply;
	char*				pSpecification;
	char				szMsg[MSG_MAX_LEN];

	g_bStartUnzip=1;

	gkRes=GK_GetMarketResponse(gkData, &Reply, &pSpecification);
	if (gkRes == GK_SUCCESS){
		sprintf(szMsg, "CTXT %ld: INQUIRE RESPONSE CALLBACK: Reply=%d, Spec=\"%s\"\n", context, Reply, pSpecification);
		fprintTimestamp(szMsg);

		if(g_bLogOnFile==1){
			fprintf(g_pOutput,"CTXT %ld: Response: Reply=%d, Spec=\"%s\"\n\n", context, Reply, pSpecification);
			fflush(g_pOutput);
		}

		GK_FreeString(pSpecification);
	}
	else{
		sprintf(szMsg, "CTXT %ld: INQUIRE RESPONSE CALLBACK: GK_GetMarketResponse() failed. Res=%d\n", context, gkRes);
		fprintTimestamp(szMsg);

		if(g_bLogOnFile==1){
			fprintf(g_pOutput, "CTXT %ld: GK_GetMarketResponse failed. Res=%d\n", context, gkRes);
			g_bLogOnFile=0;
			fclose(g_pOutput);
			g_pOutput=NULL;
		}
	}
}

void inquireDataCallback(GK_Context_t context, GK_Data_t gkData, GK_Tag_t gkTag){
	GK_Reply_t			Res;
	GK_Inquire_t		inquireID=-1;
	GK_Notification_t	NotificationType;
	GK_Chain_t			Chain;
	int					bIsBinary=0;
	unsigned int		uiLen;
	char*				Data=NULL;
	char				szMsg[MSG_MAX_LEN];

	Res=GK_GetInquireID(gkData, &inquireID);
	if (Res != GK_SUCCESS){
		sprintf(szMsg, "CTXT %ld: INQUIRE DATA CALLBACK: GK_GetInquireID() failed. Res=%d\n", context, Res);
		fprintTimestamp(szMsg);
	}

	if ((Res = GK_GetNotificationType(gkData, &NotificationType)) != GK_SUCCESS){
		printf("CTXT %ld: ERRORE GK_GetNotificationType %d\n\n", context, Res);
		return;
	}

	if(NotificationType == GK_INQUIRE_DATA_NOTIFICATION){
		sprintf(szMsg, "CTXT %ld: INQUIRE DATA CALLBACK:", context);
		fprintTimestamp(szMsg);
	}
	else if(NotificationType == GK_BINARY_INQUIRE_DATA_NOTIFICATION){
		bIsBinary=1;
		sprintf(szMsg, "CTXT %ld: BINARY INQUIRE DATA CALLBACK:", context);
		fprintTimestamp(szMsg);
	}
	else{
		sprintf(szMsg, "CTXT %ld: INVALID CALLBACK TYPE %d on inquireDataCallback", context, NotificationType);
		fprintTimestamp(szMsg);
		return;
	}
	
	if ((Res = GK_GetChain(gkData, &Chain)) != GK_SUCCESS){
		printf("  ERRORE GK_GetChain %d\n\n", Res);
		return;
	}
	
	if(bIsBinary){
		if(g_bStartUnzip == 1){
			g_bStartUnzip=0;

			if(Chain != GK_CHAIN_NO_DATA){
				if((Res = GK_CreateUnzipHelper(&g_UnzipHelper)) != GK_SUCCESS){
					printf("  ERRORE: GK_CreateUnzipHelper %d\n\n", Res);

					if(g_bLogOnFile==1){
						fprintf(g_pOutput, "CTXT %ld: ERRORE: GK_CreateUnzipHelper %d\n", context, Res);
						fflush(g_pOutput);
					}
					return;
				}
			}

			if(g_bLogOnFile==1){
				FILE* pFile=fopen(".\\OutUnzip.log","a");
				if(pFile){
					fprintfTimestamp(pFile,":");
					fclose(pFile);
				}
			}
		}

		if ((Res = GK_GetBinaryData(gkData, (GK_Byte_t**)&Data, &uiLen)) != GK_SUCCESS){
			printf("  ERRORE: GK_GetBinaryData %d\n\n", Res);

			if(g_bLogOnFile==1){
				fprintf(g_pOutput, "CTXT %ld: ERRORE: GK_GetBinaryData %d\n", context, Res);
				fflush(g_pOutput);
			}
			return;
		}

		printf("  Chain=%d. DataLen=%u\n\n", Chain, uiLen);

		if(g_bLogOnFile==1){
			FILE* pFile;

			fprintf(g_pOutput, "CTXT %ld: Chain=%d. DataLen=%u\n\n", context, Chain, uiLen);
			fflush(g_pOutput);

			sprintf(szMsg, ".\\OutZipped_InquireID_%ld.log", inquireID);
			pFile=fopen(szMsg,"ab");
			if(pFile){
				fwrite(Data,1,uiLen,pFile);
				fclose(pFile);
			}
			else{
				printf("  ERRORE: Failed opening file [%s]\n\n", szMsg);
			}
		}
	}
	else{
		if ((Res = GK_DecodeData(gkData, &Data)) != GK_SUCCESS){
			printf("  ERRORE: GK_DecodeData %d\n\n", Res);
			return;
		}

		printf("  Chain=%d. Data=\"%s\"\n\n", Chain, Data);

		if(g_bLogOnFile==1){
			fprintf(g_pOutput, "CTXT %ld: Chain=%d. Data=\"%s\"\n", context, Chain, Data);
			fflush(g_pOutput);
		}
	}

	if(bIsBinary==1){
		if(Chain != GK_CHAIN_NO_DATA){
			Inflate(context,uiLen,Data);

			if(Chain == GK_CHAIN_END){
				Res = GK_DestroyUnzipHelper(g_UnzipHelper);
				if(Res != GK_SUCCESS){
					printf("  ERRORE: GK_DestroyUnzipHelper %d\n\n", Res);

					if(g_bLogOnFile==1){
						fprintf(g_pOutput, "CTXT %ld: ERRORE: GK_DestroyUnzipHelper %d\n", context, Res);
						fflush(g_pOutput);
					}
				}
			}
		}
	}

	GK_FreeString(Data);
}

unsigned __stdcall DispatchThreadProc(void* lpParameter){
	fd_set			readfds;
	TIMEVAL			timeout;
	DISP_DATA*		pDispData;
	GK_Reply_t		gkReply;
	char			szMsg[MSG_MAX_LEN];

	pDispData=(DISP_DATA*)lpParameter;

	sprintf(szMsg, "CTXT %ld: Started ThreadID 0x%x", pDispData->gkContext, GetCurrentThreadId());
	fprintTimestamp(szMsg);

	pDispData->iEndDispatch = 0;
	while(!(pDispData->iEndDispatch)){

		FD_ZERO(&readfds);
		FD_SET((int)pDispData->gkConnection,&readfds);

		timeout.tv_sec=DISPATCH_PERIOD;
		timeout.tv_usec=0;

//		sprintf(szMsg,"CTXT %d: Calling select", pDispData->gkContext);
//		fprintTimestamp(szMsg);

		if(select((int)pDispData->gkConnection+1,&readfds,NULL,NULL,&timeout)!=SOCKET_ERROR)
		{
			if(pDispData->iEndDispatch==0)
			{
//				sprintf(szMsg,"CTXT %ld: Calling GK_Dispatch", pDispData->gkContext);
//				fprintTimestamp(szMsg);

				gkReply = GK_Dispatch(pDispData->gkContext);
				if(gkReply != GK_SUCCESS)
				{
					sprintf(szMsg, "CTXT %ld: GK_Dispatch failed. Result code=%d", pDispData->gkContext, gkReply);
					fprintTimestamp(szMsg);
					break;
				}
				else
				{
//					sprintf(szMsg,"CTXT %ld: GK_Dispatch ok\n", pDispData->gkContext);
//					fprintTimestamp(szMsg);
				}
			}
			else
			{
//				sprintf(szMsg,"CTXT %ld: Loop stopped ok\n", pDispData->gkContext);
//				fprintTimestamp(szMsg);
			}
		}
		else
		{
			int nSocketError=WSAGetLastError();
			sprintf(szMsg, "CTXT %ld: Socket error %d", pDispData->gkContext, nSocketError);
			fprintTimestamp(szMsg);
			break;
		}
	}

	sprintf(szMsg, "CTXT %ld: Closed  ThreadID 0x%x", pDispData->gkContext, GetCurrentThreadId());
	fprintTimestamp(szMsg);

	_endthreadex(0);
	return 0;
}

int main(int argc, char** argv){
	int iRes;
	int i;
	int	iKey;
	GK_Context_t	gkContext;
	GK_Context_t	myContext;
	GK_Connection_t	gkConnection;
	GK_ApplicationData_t*	pApplData=NULL;
	GK_ApplicationData_t*	pApplData2=NULL;
	GK_Transaction_t	TransactionId;
	GK_Subscription_t	mySubscriptionID;
	GK_Inquire_t		lInquireID=-1;
	GK_Inquire_t		lInquireID2=-1;
	GK_Transaction_t	myTransactionId;	
	int					nDelay=0;
	GK_Subscription_t	lSubscriptionID;
	GK_Subscription_t	mySubscriptionId;

	char				szServer[100];
	char				szUser[100];
	char				szPwd[100];
	char				szMember[100];
	char				szClientIP[100];
	char				szClientData[1000];
	char				szClassName[200];
	char				szClassData[MSG_MAX_LEN];
	char				szClassName2[200];
	char				szClassData2[MSG_MAX_LEN];
	char				szMsg[MSG_MAX_LEN];

	char* Company=NULL;
	char* Version=NULL;
	char* CreationDate=NULL;
	char* Comment=NULL;

	unsigned uThreadID=0;
	HANDLE hndThread=NULL;
	DWORD dwRes;

	GK_ApplicationData_t* pApplicationData=NULL;
	TIMEVAL timeout;
	fd_set readfds;

	printf("GKApi tester (09/03/2016)\n\n");

	for(i = 1; i<argc; i++)
	{
		if(strcmp(argv[i], "-c") == 0)
		{
			i++;
			if(i<argc)
			{
				g_iChunk = atoi(argv[i]);
				if(g_iChunk<=0)
				{
					fprintf(stderr,"ERROR: value[%s] of parameter -c is not valid\n\n",argv[i]);
					return 0;
				}
			}
			else
			{
				fprintf(stderr,"ERROR: missing value of parameter -c\n\n");
				return 0;
			}
		}
		else
		{
			fprintf(stderr,"ERROR: unknown parameter %d [%s]\n\n",i,argv[i]);
			return 0;
		}
	}

	printf("Chunk size for binary unzip: %d\n\n",g_iChunk);

	for(i=0;i<MAX_CONTEXT_NUM;i++)
	{
		g_aDispData[i].iValid=0;
		g_aDispData[i].gkContext=i;
		g_aDispData[i].gkConnection=-1;
		g_aDispData[i].iEndDispatch=0;
		g_aDispData[i].hndThread=NULL;
	}

	if (GK_GetVersion(&Company, &Version, &CreationDate, &Comment) != GK_SUCCESS){
		fprintTimestamp("Error on GK_GetVersion");
		exit(1);
	}
	
	printf("Company = %s\nVersion = %s\nCreation Date = %s\nComment = %s\n\n",
				Company, Version, CreationDate, Comment);

	GK_FreeString(Company);
	GK_FreeString(Version);
	GK_FreeString(CreationDate);
	GK_FreeString(Comment);
	Company=NULL;
	Version=NULL;
	CreationDate=NULL;
	Comment=NULL;

	iRes = GK_Initialize("GKApi.cfg");
	sprintf(szMsg,"GK_Initialize = %d\n", iRes);
	fprintTimestamp(szMsg);
	
	while(1){
		fprintTimestamp("MENU:");
		printf(" 0) CREATE CONTEXT              13) SUBSCRIBE CREATE TRANSACTION\n");
		printf(" 1) START DISPATCH THREAD       14) UNSUBSCRIBE\n");
		printf(" 2) DISPATCH                    15) SET NOTIFICATION PERIOD\n");
		printf(" 3) SELECT & DISPATCH           16) DOUBLE INQUIRE\n");
		printf(" 4) CONNECT                     17) DISCONNECT\n");
		printf(" 5) CONNECT_EX                  18) RELEASE CONTEXT\n");
		printf(" 6) CREATE TRANSACTION          19) API VERSION\n");
		printf(" 7) DESTROY TRANSACTION         20) \n");
		printf(" 8) SUBMIT                      21) \n");
		printf(" 9) SUBMIT CREATE TRANSACTION   22) INITIALIZE\n");
		printf("10) INQUIRE                     23) TERMINATE\n");
		printf("11) SUBSCRIBE                   24) EXIT\n");
		printf("12) SUBSCRIBE EX\n");
		fflush(stdout);

		scanf(SCAN_FORMAT_INT, &iKey);
		
		switch(iKey){
		case 0:
			*szServer=0;
			printf("Immetti il nome del server: ");
			fflush(stdout);
			scanf("%99s", szServer);

			gkContext=-1;
			gkConnection=-1;
			iRes = GK_CreateContext(szServer, &gkContext, &gkConnection);
			sprintf(szMsg,"GK_CreateContext = %d", iRes);
			fprintTimestamp(szMsg);

			if(iRes == GK_SUCCESS)
			{
				printf("  context = %ld\n", gkContext);
				printf("  conn = %" GKF_CONNECTION_T_PRINTF_FORMAT "\n", gkConnection);

				if(gkContext<MAX_CONTEXT_NUM)
				{
					g_aDispData[gkContext].iValid=1;
					g_aDispData[gkContext].gkConnection=gkConnection;
				}
				else
				{
					sprintf(szMsg,"Too much contexts created [%ld]", gkContext);
					fprintTimestamp(szMsg);
					exit(1);
				}
			}
		break;
		
		case 1:
			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			if(myContext<0 || myContext>=MAX_CONTEXT_NUM)
			{
				sprintf(szMsg,"Invalid context [%ld]", myContext);
				fprintTimestamp(szMsg);
				break;
			}

			hndThread=(HANDLE)_beginthreadex(NULL,0,DispatchThreadProc,(LPVOID)&g_aDispData[myContext],0,&uThreadID);
			if(((unsigned long)hndThread)==0){
				int nErr=errno;
				unsigned long ulDosErr=_doserrno;
				sprintf(szMsg,"Errore nella creazione del thread. errno=%d. _doserrno=%d", nErr, ulDosErr);
				fprintTimestamp(szMsg);
				break;
			}
			g_aDispData[myContext].hndThread=hndThread;

			sprintf(szMsg,"Created ThreadID 0x%x", uThreadID);
			fprintTimestamp(szMsg);
		break;
		
		case 2:
			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			fprintTimestamp("Calling GK_Dispatch");
			iRes = GK_Dispatch(myContext);
			sprintf(szMsg,"GK_Dispatch=%d", iRes);
			fprintTimestamp(szMsg);
		break;
		
		case 3:
			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			if(myContext<0 || myContext>=MAX_CONTEXT_NUM || g_aDispData[myContext].iValid==0)
			{
				sprintf(szMsg,"Invalid context [%ld]", myContext);
				fprintTimestamp(szMsg);
				break;
			}

			timeout.tv_sec=DISPATCH_PERIOD;
			timeout.tv_usec=0;

			FD_ZERO(&readfds);
			FD_SET((int)g_aDispData[myContext].gkConnection,&readfds);

			sprintf(szMsg,"Calling select (timeout=%d sec)", timeout.tv_sec);
			fprintTimestamp(szMsg);
			if(select((int)g_aDispData[myContext].gkConnection+1,&readfds,NULL,NULL,&timeout)!=SOCKET_ERROR)
			{
				fprintTimestamp("Calling GK_Dispatch");
				iRes = GK_Dispatch(myContext);
				sprintf(szMsg,"GK_Dispatch=%d", iRes);
				fprintTimestamp(szMsg);
			}
			else
			{
				int nSocketError=WSAGetLastError();
				sprintf(szMsg,"select error=%d",nSocketError);
				fprintTimestamp(szMsg);
			}
		break;
		
		case 4:
			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			*szUser=0;
			*szPwd=0;
			*szMember=0;

			printf("Immetti lo User: ");
			fflush(stdout);
			scanf("%99s", szUser);

			printf("Immetti la Password: ");
			fflush(stdout);
			scanf("%99s", szPwd);

			printf("Immetti il Member: ");
			fflush(stdout);
			scanf("%99s", szMember);

			iRes = GK_Connect(myContext, szUser, szPwd, szMember, connectResponseCallback, marketStatusCallback, NULL);
			sprintf(szMsg,"GK_Connect = %d", iRes);
			fprintTimestamp(szMsg);
		
		break;
		
		case 5:
			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			*szUser=0;
			*szPwd=0;
			*szMember=0;
			*szClientIP=0;
			*szClientData=0;

			printf("Immetti lo User: ");
			fflush(stdout);
			scanf("%99s", szUser);

			printf("Immetti la Password: ");
			fflush(stdout);
			scanf("%99s", szPwd);

			printf("Immetti il Member: ");
			fflush(stdout);
			scanf("%99s", szMember);

			printf("Immetti il ClientIP: ");
			fflush(stdout);
			scanf("%99s", szClientIP);

			printf("Immetti il ClientData: ");
			fflush(stdout);
			scanf("%999s", szClientData);

			iRes = GK_ConnectEx(myContext, szUser, szPwd, szMember, szClientIP, szClientData, connectResponseCallback, marketStatusCallback, NULL);
			sprintf(szMsg,"GK_ConnectEx = %d", iRes);
			fprintTimestamp(szMsg);

		break;

		case 6:
			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			if ((iRes = GK_CreateTransaction(myContext, &TransactionId)) != GK_SUCCESS){
				sprintf(szMsg,"ERRORE nella creazione della transazione, err = %d", iRes);
				fprintTimestamp(szMsg);
			} else {
				sprintf(szMsg,"Creato TransactionID = %ld", TransactionId);
				fprintTimestamp(szMsg);
			}
		break;

		case 7:
			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			myTransactionId=0;
			printf("Immetti il transaction ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myTransactionId);
		
			if ((iRes = GK_DestroyTransaction(myContext, myTransactionId)) != GK_SUCCESS){
				sprintf(szMsg,"ERRORE nella GK_DestroyTransaction, err=%d", iRes);
				fprintTimestamp(szMsg);
			}
			else {
				fprintTimestamp("Inviata destroy transaction");
			}
		break;

		case 8:
			myTransactionId=0;
			*szClassName=0;
			*szClassData=0;

			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			printf("Immetti il transaction ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myTransactionId);
		
			printf("Immetti il ClassName: ");
			fflush(stdout);
			scanf("%199s", szClassName);

			printf("Immetti il ClassData: ");
			fflush(stdout);
			scanf("%1999s", szClassData);

			iRes=GK_CreateApplicationData(szClassName,GK_MARKET_CLASS,&pApplData);
			if (iRes != GK_SUCCESS){
				sprintf(szMsg,"ERRORE nella GK_CreateApplicationData, err=%d", iRes);
				fprintTimestamp(szMsg);
			}
			else{
				iRes=GK_EncodeData(pApplData, szClassData);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_EncodeData, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
				else{
					iRes = GK_Submit(myContext, myTransactionId, pApplData,
										submitResponseCallback,	NULL);
					if (iRes != GK_SUCCESS){
						sprintf(szMsg,"ERRORE nella GK_Submit, err=%d", iRes);
						fprintTimestamp(szMsg);
					}
					else {
						fprintTimestamp("Submit ok");
					}
				}

				iRes=GK_DestroyApplicationData(pApplData);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_DestroyApplicationData, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
			}
		break;
		
		case 9:
			myTransactionId=0;
			*szClassName=0;
			*szClassData=0;

			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			printf("Immetti il transaction ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myTransactionId);
		
			printf("Immetti il ClassName: ");
			fflush(stdout);
			scanf("%199s", szClassName);

			printf("Immetti il ClassData: ");
			fflush(stdout);
			scanf("%1999s", szClassData);

			iRes=GK_CreateApplicationData(szClassName, GK_MARKET_CLASS, &pApplicationData);
			if (iRes != GK_SUCCESS){
				sprintf(szMsg,"ERRORE nella GK_CreateApplicationData, err=%d", iRes);
				fprintTimestamp(szMsg);
			}
			else{
				iRes=GK_EncodeData(pApplicationData, szClassData);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_EncodeData, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
				else{
					iRes=GK_SetTransactionID(pApplicationData, myTransactionId);
					if (iRes != GK_SUCCESS){
						sprintf(szMsg,"ERRORE nella GK_SetTransactionID, err=%d", iRes);
						fprintTimestamp(szMsg);
					}
					else{
						if ((iRes = GK_Submit(myContext, myTransactionId, pApplicationData,
											submitResponseCallback,	NULL)) != GK_SUCCESS){
							sprintf(szMsg,"ERRORE nella GK_Submit, err=%d", iRes);
							fprintTimestamp(szMsg);
						}
						else {
							fprintTimestamp("Submit ok");
						}
					}
				}

				iRes=GK_DestroyApplicationData(pApplicationData);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_DestroyApplicationData, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
			}
		break;

		case 10:
			g_bLogOnFile=0;
			*szClassName=0;
			*szClassData=0;

			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			printf("Immetti il ClassName: ");
			fflush(stdout);
			scanf("%199s", szClassName);

			printf("Immetti il ClassData: ");
			fflush(stdout);
			scanf("%1999s", szClassData);

			printf("Log su file (0/1)?  : ");
			fflush(stdout);
			scanf(SCAN_FORMAT_INT, &g_bLogOnFile);

			iRes=GK_CreateApplicationData(szClassName, GK_MARKET_CLASS, &pApplData);
			if (iRes != GK_SUCCESS){
				sprintf(szMsg,"ERRORE nella GK_CreateApplicationData, err=%d", iRes);
				fprintTimestamp(szMsg);
			}
			else{
				iRes=GK_EncodeData(pApplData, szClassData);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_EncodeData, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
				else{
					if(g_bLogOnFile==1){
						if(g_pOutput==NULL)
							g_pOutput=fopen(".\\Out.log","a");

						fprintf(g_pOutput,"********************************************\n");
						fprintf(g_pOutput,"Inquire:\n");
						fprintf(g_pOutput,"\tContext ID: %ld\n", myContext);
						fprintf(g_pOutput,"\tClass name: \"%s\"\n", szClassName);
						fprintf(g_pOutput,"\tClass data: \"%s\"\n\n", szClassData);
						fflush(g_pOutput);
					}

					if ((iRes = GK_Inquire(myContext, pApplData,
										inquireResponseCallback, inquireDataCallback,
										NULL, &lInquireID)) != GK_SUCCESS){
						sprintf(szMsg,"ERRORE nella GK_Inquire, err=%d", iRes);
						fprintTimestamp(szMsg);

						if(g_bLogOnFile==1){
							fprintf(g_pOutput,"GK_Inquire failed. Res=%d\n",iRes);
							g_bLogOnFile=0;
							fclose(g_pOutput);
							g_pOutput=NULL;
						}
					}
					else {
						sprintf(szMsg,"Creato InquireID = %ld", lInquireID);
						fprintTimestamp(szMsg);
					}
				}

				iRes=GK_DestroyApplicationData(pApplData);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_DestroyApplicationData, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
			}
		break;

		case 11:
			*szClassName=0;
			*szClassData=0;

			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			printf("Immetti il ClassName: ");
			fflush(stdout);
			scanf("%199s", szClassName);

			printf("Immetti il ClassData: ");
			fflush(stdout);
			scanf("%1999s", szClassData);

			iRes=GK_CreateApplicationData(szClassName, GK_MARKET_CLASS, &pApplData);
			if (iRes != GK_SUCCESS){
				sprintf(szMsg,"ERRORE nella GK_CreateApplicationData, err=%d", iRes);
				fprintTimestamp(szMsg);
			}
			else{
				iRes=GK_EncodeData(pApplData, szClassData);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_EncodeData, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
				else{
					if ((iRes = GK_Subscribe(myContext, pApplData,
										subscribeResponseCallback,	subscribeDataCallback,
										NULL, &lSubscriptionID)) != GK_SUCCESS){
						sprintf(szMsg,"ERRORE nella GK_Subscribe, err=%d", iRes);
						fprintTimestamp(szMsg);
					} else {
						sprintf(szMsg,"Creata SubscriptionID=%ld", lSubscriptionID);
						fprintTimestamp(szMsg);
					}
				}

				iRes=GK_DestroyApplicationData(pApplData);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_DestroyApplicationData, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
			}
		break;

		case 12:
			*szClassName=0;
			*szClassData=0;

			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			printf("Immetti il ClassName: ");
			fflush(stdout);
			scanf("%199s", szClassName);

			printf("Immetti il ClassData: ");
			fflush(stdout);
			scanf("%1999s", szClassData);

			iRes=GK_CreateApplicationData(szClassName, GK_MARKET_CLASS, &pApplData);
			if (iRes != GK_SUCCESS){
				sprintf(szMsg,"ERRORE nella GK_CreateApplicationData, err=%d", iRes);
				fprintTimestamp(szMsg);
			}
			else{
				iRes=GK_EncodeData(pApplData, szClassData);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_EncodeData, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
				else{
					if ((iRes = GK_SubscribeEx(myContext, pApplData, 10,
										subscribeResponseCallback,	subscribeDataCallback,
										NULL, &lSubscriptionID)) != GK_SUCCESS){
						sprintf(szMsg,"ERRORE nella GK_SubscribeEx, err=%d", iRes);
						fprintTimestamp(szMsg);
					} else {
						sprintf(szMsg,"Creata SubscriptionID=%ld", lSubscriptionID);
						fprintTimestamp(szMsg);
					}
				}

				iRes=GK_DestroyApplicationData(pApplData);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_DestroyApplicationData, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
			}
		break;

		case 13:
			*szClassName=0;
			*szClassData=0;
			myTransactionId=0;

			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			printf("Immetti il ClassName: ");
			fflush(stdout);
			scanf("%199s", szClassName);

			printf("Immetti il ClassData: ");
			fflush(stdout);
			scanf("%1999s", szClassData);

			printf("Immetti il TransactionID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myTransactionId);

			GK_CreateApplicationData(szClassName, GK_META_CLASS, &pApplicationData);
			GK_EncodeData(pApplicationData, szClassData);
			GK_SetTransactionID(pApplicationData, myTransactionId);
			
			if ((iRes = GK_Subscribe(myContext, pApplicationData,
								subscribeResponseCallback,	subscribeDataCallback,
								NULL, &lSubscriptionID)) != GK_SUCCESS){
				sprintf(szMsg,"ERRORE nella subscribe, err=%d", iRes);
				fprintTimestamp(szMsg);
			} else {
				sprintf(szMsg,"Creata SubscriptionID=%ld", lSubscriptionID);
				fprintTimestamp(szMsg);
			}
			
			GK_DestroyApplicationData(pApplicationData);
		break;

		case 14:
			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			printf("Immetti il subscribe ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &mySubscriptionID);
		
			if ((iRes = GK_UnSubscribe(myContext, mySubscriptionID,
										unsubscribeResponseCallback, NULL)) != GK_SUCCESS){
				sprintf(szMsg,"ERRORE nella GK_UnSubscribe, err=%d", iRes);
				fprintTimestamp(szMsg);
			}
			else{
				fprintTimestamp("Inviata UnSubscribe");
			}
		break;
		
		case 15:
			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			printf("Immetti il Subscription ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &mySubscriptionId);
			
			if ((iRes = GK_SetNotificationPeriod(myContext, mySubscriptionId, 5,
								NotificationPeriodResponseCallback,	NULL)) != GK_SUCCESS){
				sprintf(szMsg,"ERRORE nella GK_SetNotificationPeriod, err=%d", iRes);
				fprintTimestamp(szMsg);
				exit(1);
			}

			fprintTimestamp("Inviato GK_SetNotificationPeriod");
		break;

		case 16:
			g_bLogOnFile=0;
			*szClassName=0;
			*szClassData=0;
			*szClassName2=0;
			*szClassData2=0;

			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			printf("Immetti il ClassName1: ");
			fflush(stdout);
			scanf("%199s", szClassName);

			printf("Immetti il ClassData1: ");
			fflush(stdout);
			scanf("%1999s", szClassData);

			printf("Immetti il ClassName2: ");
			fflush(stdout);
			scanf("%199s", szClassName2);

			printf("Immetti il ClassData2: ");
			fflush(stdout);
			scanf("%1999s", szClassData2);

			printf("Immetti il delay (msec): ");
			fflush(stdout);
			scanf(SCAN_FORMAT_INT, &nDelay);

			iRes=GK_CreateApplicationData(szClassName,GK_MARKET_CLASS,&pApplData);
			if (iRes != GK_SUCCESS){
				sprintf(szMsg,"ERRORE nella GK_CreateApplicationData, err=%d", iRes);
				fprintTimestamp(szMsg);
			}
			else{
				iRes=GK_EncodeData(pApplData, szClassData);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_EncodeData, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
				else{
					if ((iRes = GK_Inquire(myContext, pApplData,
										inquireResponseCallback, inquireDataCallback,
										NULL, &lInquireID)) != GK_SUCCESS){
						sprintf(szMsg,"ERRORE nella GK_Inquire 1, err=%d", iRes);
						fprintTimestamp(szMsg);
					} else {
						sprintf(szMsg,"Creata inquire 1 con ID = %ld", lInquireID);
						fprintTimestamp(szMsg);
					}
				}

				iRes=GK_DestroyApplicationData(pApplData);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_DestroyApplicationData, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
			}

			if(nDelay>0)
				Sleep(nDelay);

			iRes=GK_CreateApplicationData(szClassName2,GK_MARKET_CLASS,&pApplData2);
			if (iRes != GK_SUCCESS){
				sprintf(szMsg,"ERRORE nella GK_CreateApplicationData 2, err=%d", iRes);
				fprintTimestamp(szMsg);
			}
			else{
				iRes=GK_EncodeData(pApplData2, szClassData2);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_EncodeData 2, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
				else{
					if ((iRes = GK_Inquire(myContext, pApplData2,
										inquireResponseCallback, inquireDataCallback,
										NULL, &lInquireID2)) != GK_SUCCESS){
						sprintf(szMsg,"ERRORE nella GK_Inquire 2, err=%d", iRes);
						fprintTimestamp(szMsg);
					} else {
						sprintf(szMsg,"Creata inquire 2 con ID = %ld", lInquireID2);
						fprintTimestamp(szMsg);
					}
				}

				iRes=GK_DestroyApplicationData(pApplData2);
				if (iRes != GK_SUCCESS){
					sprintf(szMsg,"ERRORE nella GK_DestroyApplicationData 2, err=%d", iRes);
					fprintTimestamp(szMsg);
				}
			}
		break;

		case 17:
			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			iRes = GK_Disconnect(myContext, disconnectResponseCallback, NULL);
			if (iRes != GK_SUCCESS){
				sprintf(szMsg,"ERRORE nella Disconnect, err=%d", iRes);
				fprintTimestamp(szMsg);
			}
			else
				fprintTimestamp("Inviata Disconnect");
		break;

		case 18:
			myContext=-1;
			printf("Immetti il context ID: ");
			fflush(stdout);
			scanf(SCAN_FORMAT_LONG, &myContext);

			if(myContext<0 || myContext>=MAX_CONTEXT_NUM || g_aDispData[myContext].iValid==0)
			{
				sprintf(szMsg,"Invalid context [%ld]", myContext);
				fprintTimestamp(szMsg);
				break;
			}

			if(g_aDispData[myContext].hndThread != NULL)
			{
				g_aDispData[myContext].iEndDispatch=1;
				dwRes=WaitForSingleObject(g_aDispData[myContext].hndThread,DISPATCH_PERIOD*2000);
				switch(dwRes)
				{
				case WAIT_ABANDONED:
					sprintf(szMsg,"WaitForSingleObject = WAIT_ABANDONED");
					break;
				case WAIT_OBJECT_0:
					sprintf(szMsg,"WaitForSingleObject = WAIT_OBJECT_0");
					break;
				case WAIT_TIMEOUT:
					sprintf(szMsg,"WaitForSingleObject = WAIT_TIMEOUT");
					break;
				case WAIT_FAILED:
					dwRes=GetLastError();
					sprintf(szMsg,"WaitForSingleObject = WAIT_FAILED. Error = %d",dwRes);
					break;
				}
				fprintTimestamp(szMsg);
			}

			iRes = GK_ReleaseContext(myContext);
			sprintf(szMsg,"GK_ReleaseContext = %d",iRes);
			fprintTimestamp(szMsg);

			g_aDispData[myContext].iValid=0;
			g_aDispData[myContext].gkConnection=-1;
			g_aDispData[myContext].iEndDispatch=0;
			g_aDispData[myContext].hndThread=NULL;
		break;
		
		case 19:
			if (GK_GetVersion(&Company, &Version, &CreationDate, &Comment) != GK_SUCCESS){
				fprintTimestamp("Error on GK_GetVersion");
			}
			else
			{
				printf("Company = %s\nVersion = %s\nCreation Date = %s\nComment = %s\n\n",
							Company, Version, CreationDate, Comment);

				GK_FreeString(Company);
				GK_FreeString(Version);
				GK_FreeString(CreationDate);
				GK_FreeString(Comment);
				Company=NULL;
				Version=NULL;
				CreationDate=NULL;
				Comment=NULL;
			}
			break;

		case 22:
			iRes = GK_Initialize("GKApi.cfg");
			sprintf(szMsg,"GK_Initialize = %d", iRes);
			fprintTimestamp(szMsg);
			break;

		case 23:
			iRes = GK_Terminate();
			sprintf(szMsg,"GK_Terminate = %d", iRes);
			fprintTimestamp(szMsg);
			break;

		case 24:
			iRes = GK_Terminate();
			sprintf(szMsg,"GK_Terminate = %d", iRes);
			fprintTimestamp(szMsg);

			exit(0);
			break;
		}
		printf("\n");
	}
}
